
#include "app.h"

unsigned short *EmuScreen=NULL;
int EmuWidth=0,EmuHeight=0;

int EmuInit()
{
  int len=0;
  // Allocate screen:
  EmuWidth=640; EmuHeight=480;
  len=EmuWidth*EmuHeight; len<<=1;
  EmuScreen=(unsigned short *)malloc(len); if (EmuScreen==NULL) return 1;
  memset(EmuScreen,0,len);
  return 0;
}

void EmuExit()
{
  free(EmuScreen); EmuScreen=NULL; // Deallocate screen
  EmuWidth=EmuHeight=0;

}

// Megadrive scanline callback:
int EmuScan(unsigned int num,unsigned short *pal,unsigned char *sdata)
{
  unsigned short *pd=NULL,*end=NULL;
  unsigned char *ps=NULL;

  if (num>=(unsigned int)EmuHeight) return 0;

  // Copy scanline to screen buffer:
  pd=EmuScreen+(num<<8)+(num<<6); end=pd+320;
  ps=sdata;

  do { *pd++=pal[*ps++]; } while (pd<end);
  
  return 0;
}

int EmuFrame()
{
  return 0;
}
